package edu.cmu.cs.cs214.concurrencyframework;

import java.util.concurrent.RecursiveAction;

public class PrefixSumsParallelLoop1 extends RecursiveAction {
    private final long[] a;
    private final int left, right, gap, twiceGap;

    public static final int RECURSIVE_LIMIT = 100000;  // If the loop runs fewer than this many times 
    // then run the loop sequentially.  Otherwise 
    // run the task in parallel.

    public PrefixSumsParallelLoop1(long[] a, int left, int right, int gap, int twiceGap) {
	this.a = a;
	this.left = left;
	this.right = right;
	this.gap = gap;
	this.twiceGap = twiceGap;
    }

    protected void compute() {
	final int width = right-left;
	if (width/twiceGap < RECURSIVE_LIMIT) {                       // Our base case is exactly the 
	    for (int i = left+gap-1; i+gap < right; i += twiceGap) {  // first loop from the non-
		a[i+gap] = a[i] + a[i+gap];                           // sequential implementation.
	    }
	    return;
	}

	invokeAll(new PrefixSumsParallelLoop1(a, left, left+width/2, gap, twiceGap),
		new PrefixSumsParallelLoop1(a, left+width/2, right, gap, twiceGap));
    }
}
